//******************************************************************************
//  MSP430x11x1 Demo - Timer_A, Ultra-Low Pwr UART 4800 Echo, 32kHz ACLK
//  Description: TX is called in ISR, ACLK drives Timer_A and remains on in LPM3
//  TACCR0 generates 1 second interrupt.
//
//  L. Westlund / A. Dannenberg
//  Texas Instruments Inc.
//  July 2007
//  Built with IAR Embedded Workbench Version: 3.42A
//*****************************************************************************
#include "ta_uart.h"
#include <msp430x11x1.h>

int callBack( unsigned char c );

void main (void)
{
  WDTCTL = WDTPW + WDTHOLD;                 // Stop watchdog timer

  TI_initTimer(callBack, _32Khz_ACLK_04800_Bitime, TASSEL_1);
  P1DIR |= 0x01;
  TACTL |= TACLR;
  TACCTL0 = CCIE;                           // TACCR0 interrupt enabled
  TACCR0 = 32768-1;
  _EINT();
  LPM3;
}

int callBack( unsigned char c )
{
  TI_TA_UART_StatusFlags &= ~TI_TA_RX_RECEIVED; // allows for RX during TX (will not effect TXed byte)
  TI_TX_Byte( c );                          // echo byte
  return TA_UART_STAY_LPM;                  // return to LPM3
}

// Timer A0 interrupt service routine
#pragma vector=TIMERA0_VECTOR
__interrupt void Timer_A (void)
{
  P1OUT ^= 0x01;                            // Toggle P1.0
  TACCR0 += 32768;                          // Add Offset to TACCR0
}
