//******************************************************************************
//  MSP430x11x1 Demo - Timer_A, LPM0 UART 9600 Echo, 32kHz ACLK
//  Description: Echo, then return to LPM0, SMCLK remains on for TX
//
//  L. Westlund
//  Texas Instruments Inc.
//  Feb 2006
//  Built with IAR Embedded Workbench Version: 3.40
//*****************************************************************************
#include "ta_uart.h"
#include <msp430x11x1.h>

#define DELTA     244                       // Target DCO = DELTA*(4096) ~1MHz
void Set_DCO (void);
int callBack( unsigned char c );

void main (void)
{
  WDTCTL = WDTPW + WDTHOLD;                 // Stop watchdog timer

  BCSCTL1 |= DIVA_3;                        // ACLK = LFXT1CLK/8
  Set_DCO();                                // Set DCO
  BCSCTL1 &= ~DIVA_3;                       // ACLK = LFXT1CLK

  TI_initTimer(callBack, _1MHz_SMCLK_09600_Bitime, TASSEL_2);
  _EINT();
  LPM0;
}

int callBack( unsigned char c )
{
  TI_TA_UART_StatusFlags &= ~TI_TA_RX_RECEIVED; // allows for RX during TX (will not effect TXed byte)
  TI_TX_Byte( c );                          // echo byte
  return TA_UART_STAY_LPM;                  // return to LPM0
}

//------------------------------------------------------------------------------
void Set_DCO (void)                         // Set DCO to selected frequency
//------------------------------------------------------------------------------
{
  unsigned int Compare, Oldcapture = 0;

  TACCTL2 = CM_1 + CCIS_1 + CAP;            // CAP, ACLK
  TACTL = TASSEL_2 + MC_2 + TACLR;          // SMCLK, cont-mode, clear

  while (1)
  {
    while (!(CCIFG & TACCTL2));             // Wait until capture occured
    TACCTL2 &= ~CCIFG;                      // Capture occured, clear flag
    Compare = TACCR2;                       // Get current captured SMCLK
    Compare = Compare - Oldcapture;         // SMCLK difference
    Oldcapture = TACCR2;                    // Save current captured SMCLK
    if (DELTA == Compare) break;            // If equal, leave "while(1)"

    else if (DELTA < Compare)
    {
      DCOCTL--;
      if (DCOCTL == 0xFF)                   // DCO is too fast, slow it down
      {
        if (!(BCSCTL1 == (XT2OFF + DIVA_3)))
        BCSCTL1--;                          // Did DCO role under?, Sel lower RSEL
      }
    }
    else
    {
      DCOCTL++;                             // DCO is too slow, speed it down
      if (DCOCTL == 0x00)
      {
        if (!(BCSCTL1 == (XT2OFF + DIVA_3 + 0x07)))
        BCSCTL1++;                          // Did DCO role over? Sel higher RSEL
      }
    }
  }

  TACCTL2 = 0;                              // Stop TACCR2
  TACTL = 0;                                // Stop Timer_A
}
