//******************************************************************************
//  MSP430x11x1 Demo - Timer_A, UART 9600 Echo, 32kHz ACLK
//
//  L. Westlund
//  Texas Instruments Inc.
//  August 2007
//  Built with IAR Embedded Workbench Version: 3.42A
//*****************************************************************************
#include "ta_uart_32khz_9600.h"
#include <msp430x11x1.h>

int callBack( unsigned char c );

void main (void)
{
  WDTCTL = WDTPW + WDTHOLD;                 // Stop watchdog timer

  TI_initTimer(callBack);

  _BIS_SR(LPM3_bits + GIE);                 // Enter LPM3 w/ interr until char RXed

}

int callBack( unsigned char c )
{
  TI_TA_UART_StatusFlags &= ~TI_TA_RX_RECEIVED; // allows for RX during TX (will not effect TXed byte)
  TI_TX_Byte( c );
  return TA_UART_STAY_LPM;
}
